

import org.exolab.castor.builder.SourceGenerator;
import org.exolab.castor.xml.Marshaller;
import java.io.FileReader;
import java.io.FileWriter;
import company.*;
import person.*;
import product.*;

public class makeCompanyFile
{
 
    public static void main(String[] args)
    {
	try
	    {
		// Read in the contents of the xml file
		FileReader reader = new FileReader ("company.xml");
		company.Company c = (Company) company.Company.unmarshal(reader);

		// Add some more Persons and Products to the company
		company.Person p1 = new company.Person();
		p1.setFirstname("Fred");
		p1.setSurname("Jones");
		c.addPerson(p1);
		company.Person p2 = new company.Person();
		p2.setFirstname("Mary");
		p2.setSurname("Smith");
		c.addPerson(p2);
		company.Product d = new company.Product();
		d.setType("spoon");
		c.addProduct(d);

		// Write out the new xml file together with namespaces
		FileWriter writer = new FileWriter("newCompany.xml");
                Marshaller m = new Marshaller(writer);
                m.setSchemaLocation("http://users.aber.ac.uk/afc/company company.xsd\n\t http://users.aber.ac.uk/afc/person person.xsd\n\t http://users.aber.ac.uk/afc/product product.xsd");
                m.setNamespaceMapping("per",
				      "http://users.aber.ac.uk/afc/person");
                m.setNamespaceMapping("pro",
				      "http://users.aber.ac.uk/afc/product");
                m.marshal(c);
	    }
	catch(Exception e)
	    {
		System.out.println(e.toString());
	    }
    }
}
